package gov.va.med.mhv.admin.registry;

import gov.va.med.mhv.admin.enums.StatusType;


public class Status {
	private StatusType statusType;
	private String statusDescription;
	
	public Status()
	{
		super();
	}
	
	public Status(StatusType status, String statusDescription)
	{
		super();
		this.setStatusType(status);
		this.setStatusDescription(statusDescription);
	}
	
	public StatusType getStatusType() {
		return statusType;
	}
	
	public void setStatusType(StatusType status) {
		this.statusType = status;
//		if(status==null)
//			this.status=null;
//		else
//		{	
//			if(StatusType.valueOf(status)!=null)
//				this.status=status;
//			else
//				throw new IllegalArgumentException("Permitted values are Fail, Reject, Error or Ok!");
//		}
	}
	
	public String getStatusDescription() {
		return statusDescription;
	}
	
	public void setStatusDescription(String statusDescription) {
		this.statusDescription = (statusDescription!=null && statusDescription.length()>4000)?statusDescription.substring(0, 3500):statusDescription;
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((statusType == null) ? 0 : statusType.hashCode());
		result = PRIME * result + ((statusDescription == null) ? 0 : statusDescription.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Status other = (Status) obj;
		if (statusType == null) {
			if (other.statusType != null)
				return false;
		} else if (!statusType.equals(other.statusType))
			return false;
		if (statusDescription == null) {
			if (other.statusDescription != null)
				return false;
		} else if (!statusDescription.equals(other.statusDescription))
			return false;
		return true;
	}
}
